/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.util.Comparators;
import java.util.Comparator;
import javax.annotation.Nonnull;

public class MaterialQuantity {
    private final Material material;
    private final double qty;
    private final double batch;
    private static Comparator<MaterialQuantity> comparator;

    public MaterialQuantity(@Nonnull Material mat, double qty, double batch) {
        if (!Double.isFinite(qty)) {
            throw new IllegalArgumentException("Quantity is not finite for " + mat);
        }
        this.material = Preconditions.checkNotNull(mat, "material");
        this.qty = qty;
        this.batch = batch;
    }

    public MaterialQuantity(Material mat, double qty) {
        this(mat, qty, 0.0);
    }

    public Material getMaterial() {
        return this.material;
    }

    public double getQty() {
        return this.qty;
    }

    public double getBatch() {
        return this.batch;
    }

    public String toString() {
        return String.format("[%s;%.1f;%.1f]", this.material.toString(), this.qty, this.batch);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaterialQuantity)) {
            return false;
        }
        MaterialQuantity that = (MaterialQuantity)o;
        return Double.compare(that.qty, this.qty) == 0 && Double.compare(that.batch, this.batch) == 0 && this.material.equals(that.material);
    }

    public int hashCode() {
        int result = this.getMaterial() != null ? this.getMaterial().hashCode() : 0;
        long temp = Double.doubleToLongBits(this.getQty());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getBatch());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static Comparator<MaterialQuantity> comparator() {
        if (comparator == null) {
            comparator = new Comparator<MaterialQuantity>(){
                final Ordering<Object> matOrder = Ordering.arbitrary();

                @Override
                public int compare(MaterialQuantity o1, MaterialQuantity o2) {
                    int res = Comparators.compare(o1.getQty(), o2.getQty());
                    if (res == 0) {
                        res = this.matOrder.compare(o1.getMaterial(), o2.getMaterial());
                    }
                    return res;
                }
            };
        }
        return comparator;
    }
}

